//
//  MCApplicationUpdater.h
//  MCApplication
//
//  Created by Michael Clark on Sun Oct 27 2002.
//  Copyright (c) 2002 __MyCompanyName__. All rights reserved.
//

// Details:  This class will look for a file at a given url.  The file should be in the following format:
// VERSION
// BUILD
// UPDATE PATH
// MORE INFO PATH
//
//  Where VERSION        is the latest version, i.e. 1.2
//        BUILD          is the latest build, i.e. 100
//        UPDATE PATH    is the URL path to download the update DMG, i.e. http://mirror.marketcircle.com/downloads/up.dmg
//        MORE INFO PATH is the url path to get more info on the new version, i.e. http://www.marketcircle.com/info.html
//

#import <Cocoa/Cocoa.h>

 
@interface MCApplicationUpdater : NSObject {

    NSURL       *url;
    NSString    *version;
	NSString*    build;
    BOOL        notifyOnCurrent;
}

+ (MCApplicationUpdater *)defaultInstance;

- (void)checkURLPath: (NSString *)aURLPath forVersion: (NSString *)aVersion andBuild: (NSString*)aBuild;
- (void)checkURLPath: (NSString *)aURLPath forVersion: (NSString *)aVersion andBuild: (NSString*)aBuild notifyWhenCurrent: (BOOL)flag;
- (void)_processReceivedString: (NSString *)aStr;


// Accessors
- (NSURL *)url;
- (void)setUrl:(NSURL *)anUrl;

- (NSString *)version;
- (void)setVersion:(NSString *)aVersion;

- (NSString *)build;
- (void)setBuild:(NSString *)aBuild;

- (BOOL)notifyOnCurrent;
- (void)setNotifyOnCurrent:(BOOL)flag;

@end
